<?php

/*
Widget Name:  Contacts Widget
Description: List Limited Product Offers With Countdown Timers
Author: Shiju
*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 

class contact_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'contact_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Contacts', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Display contacts block with map and form', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
                'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Contacts Title', 'swap'),
                    'default' => ''
                ),
				 'content' => array(
                    'type' => 'textarea',
                    'label' => esc_html__('Contacts Description', 'swap'),
                    'default' => ''
                ),
                
			
               
                'form_id' => array(
                    'type' => 'text',
                    'label' => esc_html__('Contact form ID', 'swap'),
                    'default' => ''
                ),
                             
            ),

            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'contact';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('contact_widget', __FILE__, 'contact_widget');

endif;

