<?php
/*
Widget Name: Features Widget
Description: Create Features Section
Author: Shiju
*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 

class features_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'features_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Features', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Features Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
                
                 'title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Title', 'swap'),
                            'default' => ''
                        ),
                
                
                      
               'a_repeater' => array(
                    'type' => 'repeater',
                    'label' => esc_html__( 'Add record' , 'swap' ),
                    'item_name'  => esc_html__( 'Click here to setup this record', 'swap' ),
                    'item_label' => array(
                        'selector'     => "[id*='repeat_text']",
                        'update_event' => 'change',
                        'value_method' => 'val'
                    ),
                    'fields' => array(
                        'title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Title', 'swap'),
                            'default' => ''
                        ),
                        'content' => array(
                            'type' => 'tinymce',
                            'label' => esc_html__('Text', 'swap'),
                            'default' => ''
                        ),
               
                        
                        'image' => array(
                            'type' => 'media',
                            'label' => esc_html__( 'Choose  image', 'swap' ),
                            'choose' => esc_html__( 'Choose image', 'swap' ),
                            'update' => esc_html__( 'Set image', 'swap' ),
                            'library' => 'image',
                            'fallback' => true
                        ),
                       
                      
                        'visibility' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Temporary hide this record', 'swap' )
                        ),
                    )
                )
				
              
            
            ),

            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'features';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('features_widget', __FILE__, 'features_widget');

endif;


    