<?php
/*
Widget Name:  Page Widget
Description: Create Page Section
Author: Shiju
*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 

class page_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'page_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Page', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Page Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
                 'backgroundcolor' => array(
                    'type' => 'color',
                    'label' => esc_html__('Features Sub title', 'swap'),
                    'default' => '#ffffff'
                ),
                'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Page title', 'swap'),
                    'default' => ''
                ),
                
                'content' => array(
                    'type' => 'textarea',
                    'label' => esc_html__('Content', 'swap'),
                    'default' => ''
                ),
                
                   'image' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose about image', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
				'button_text' => array(
                           'type' => 'text',
                           'label' => esc_html__('Button text Store', 'swap'),
                           'default' => ''
                 ),
				'button_url' => array(
                   'type' => 'link',
                   'label' => esc_html__('Button link', 'swap'),
                   'default' => '#'
                ),
             'button_text1' => array(
                           'type' => 'text',
                           'label' => esc_html__('Button text Contact', 'swap'),
                           'default' => ''
                 ),
				'button_url1' => array(
                   'type' => 'link',
                   'label' => esc_html__('Button link', 'swap'),
                   'default' => '#'
                ),
              
            
         
                
             
            ),

            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'page';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('page_widget', __FILE__, 'page_widget');

endif;

