<?php

/*
Widget Name: Swap Process Widget
Description: Create Process Section
Author: Shiju

*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 


class process_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'process_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Process', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Process  Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
			'tagline' => array(
                    'type' => 'text',
                    'label' => esc_html__('Enter tagline ', 'swap'),
                    'default' => ''
                ),
				'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Enter title', 'swap'),
                    'default' => ''
                ),
						
						
						
						
							
				
						
						  'a_repeater' => array(
                    'type' => 'repeater',
                    'label' => esc_html__( 'Add Work process record' , 'swap' ),
                    'item_name'  => esc_html__( 'Click here to setup this record', 'swap' ),
                    'item_label' => array(
                        'selector'     => "[id*='repeat_text']",
                        'update_event' => 'change',
                        'value_method' => 'val'
                    ),
                    'fields' => array(
					
					   'image' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose process image', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
					
					    'process' => array(
                            'type' => 'text',
                            'label' => esc_html__('Process Title', 'swap'),
                            'default' => ''
                        ),
						'text' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('Process Text', 'swap'),
                            'default' => ''
                        ),
						
                       
                     
                        'visibility' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Temporary hide this record', 'swap' )
                        ),
                    )
                ),
				
					
				'button_text' => array(
                    'type' => 'text',
                    'label' => esc_html__('Enter Button Title ', 'swap'),
                    'default' => ''
                ),
              'button_url' => array(
                    'type' => 'link',
                    'label' => esc_html__('Enter Button Url ', 'swap'),
                    'default' => ''
                ),		
						
                
                	               
            
             
            ),
            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'process';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('process_widget', __FILE__, 'process_widget');

endif;