<?php
/*
Widget Name: Products Widget
Description: Create Products Section
Author: Shiju
*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 

class products_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'products_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Products', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Products Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
                    'backgroundcolor' => array(
                    'type' => 'color',
                    'label' => esc_html__('Features Sub title', 'swap'),
                    'default' => '#ffffff'
                ),
                'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Products title', 'swap'),
                    'default' => ''
                ),
                
                
                
                
                
                'columns' => array(
                    'type' => 'select',
                    'label' => esc_html__( 'Number of columns per row', 'swap'),
                    'default' => '2',
                    'options' => array(
                        '1' => esc_html__( '1 Column', 'swap'),
                        '2' => esc_html__( '2 Column', 'swap'),
                        '3' => esc_html__( '3 Column', 'swap'),
                        '4' => esc_html__( '4 Column', 'swap'),
                        '5' => esc_html__( '5 Column', 'swap'),
                        '6' => esc_html__( '6 Column', 'swap'),
                        '7' => esc_html__( '7 Column', 'swap'),
                        '8' => esc_html__( '8 Column', 'swap'),
                    )
                ),
                'products_per_page' => array(
                   'type' => 'number',
                   'label' => esc_html__('Products per page', 'swap'),
                   'default' => ''
                ),
               
                'category' => array(
                    'type' => 'text',
                    'label' => esc_html__('Category', 'swap'),
                    'description' => esc_html__('You can categorize products by categories', 'swap'),
                    'default' => ''
                ),
               
                  'button_text' => array(
                           'type' => 'text',
                           'label' => esc_html__('Button text', 'swap'),
                           'default' => ''
                 ),
                        'button_url' => array(
                           'type' => 'link',
                           'label' => esc_html__('Button link', 'swap'),
                           'default' => '#'
                        ),
            ),

            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'products';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('products_widget', __FILE__, 'products_widget');

endif;


    