<?php

/*
Widget Name: Swap Project Widget
Description: Create Project Section
Author: Shiju

*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 


class project_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'project_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Project', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create project Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(

                'backgroundcolor' => array(
                    'type' => 'color',
                    'label' => esc_html__('Background color', 'swap'),
                    'default' => '#ffffff'
                ),
				 'subtitle' => array(
                    'type' => 'text',
                    'label' => esc_html__('Project subtitle', 'swap'),
                    'default' => ''
                ),
                'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Project title', 'swap'),
                    'default' => ''
                ),
                
				'button_text' => array(
                           'type' => 'text',
                           'label' => esc_html__('Button text', 'swap'),
                           'default' => ''
                        ),
                       
						
						'projects_per_page' => array(
                   'type' => 'number',
                   'label' => esc_html__('Projects per page', 'swap'),
                   'default' => ''
                ),

                
            ),
            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'project';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('project_widget', __FILE__, 'project_widget');

endif;