<?php

/*
Widget Name: Service Single Widget
Description: Create Service Single Section
Author: Shiju

*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 


class service_single_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'service_single_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Service Single', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Service Single Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
					
					
                       
						 'title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Enter Title', 'swap'),
                            'default' => ''
                        ),
					'description' => array(
                            'type' => 'tinymce',
                            'label' => esc_html__('Enter Description', 'swap'),
                            'default' => ''
                        ),
						 'image1' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose image ', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
				 'image2' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose image', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
                 	               
               'a_repeater' => array(
                    'type' => 'repeater',
                    'label' => esc_html__( 'Add listing record' , 'swap' ),
                    'item_name'  => esc_html__( 'Click here to setup this record', 'swap' ),
                    'item_label' => array(
                        'selector'     => "[id*='repeat_text']",
                        'update_event' => 'change',
                        'value_method' => 'val'
                    ),
                    'fields' => array(
           
                
                      
					  
						 'point' => array(
                            'type' => 'text',
                            'label' => esc_html__('Enter listing points', 'swap'),
                            'default' => ''
                        ),
						
                        'visibility' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Temporary hide this record', 'swap' )
                        ),
                    )
                ),
				
			 'subtitle' => array(
                            'type' => 'text',
                            'label' => esc_html__('Enter SubTitle', 'swap'),
                            'default' => ''
                        ),
					'content' => array(
                            'type' => 'tinymce',
                            'label' => esc_html__('Enter Content', 'swap'),
                            'default' => ''
                        ),
						  'a_repeater1' => array(
                    'type' => 'repeater',
                    'label' => esc_html__( 'Add subpoints record' , 'swap' ),
                    'item_name'  => esc_html__( 'Click here to setup this record', 'swap' ),
                    'item_label' => array(
                        'selector'     => "[id*='repeat_text']",
                        'update_event' => 'change',
                        'value_method' => 'val'
                    ),
                    'fields' => array(
           
                
                      
					  
						 'subpoint' => array(
                            'type' => 'text',
                            'label' => esc_html__('Enter subpoints', 'swap'),
                            'default' => ''
                        ),
						
                        'visibility' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Temporary hide this record', 'swap' )
                        ),
                    )
                ),
                 'image3' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose image', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
                 	               
        
						
						
                
                
             
            ),
            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'service_single';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('service_single_widget', __FILE__, 'service_single_widget');

endif;