<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();


$s=get_search_query();
$args = array(
                's' =>$s
            );
    // The Query
$wp_query = new WP_Query( $args );
if (  $wp_query->have_posts() ) {
	?>
	
	
	<div class="section--bg-wrapper-02">
	
		<!-- start section -->
		<section class=" pt-6 pb-6 section__indent-11">
			<div class="container">
			    
			         <span class="">	<?php
			printf(
				/* translators: %s: Search term. */
				esc_html__( 'Results for "%s"', 'twentytwentyone' ),
				'<span class="page-description search-term">' . esc_html( get_search_query() ) . '</span>'
			);
			?></span>
                        <h5 class="">	<?php
		printf(
			esc_html(
				/* translators: %d: The number of search results. */
				_n(
					'We found %d result for your search.',
					'We found %d results for your search.',
					(int) $wp_query->found_posts,
					'twentytwentyone'
				)
			),
			(int) $wp_query->found_posts
		);
		?></h5>
				<div class="listing-post">
				    <?php

	// Start the Loop.
	while ( $wp_query->have_posts() ) {
		$wp_query->the_post();

		/*
		 * Include the Post-Format-specific template for the content.
		 * If you want to override this in a child theme, then include a file
		 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
		 */
		get_template_part( 'content','search');
	} // End the loop.?>
				    
				
				
				</div>
			
			
			 	<?php
			    if($wp_query->max_num_pages > 1)
			    { ?>
 <!-- start pagination -->
                         <div class="col-md-12 col-lg-12">
			    <?php	if (function_exists("swap_pagination")) 
			    	{?>
			    	
			    	    
			    	        <?php	    swap_pagination($wp_query->max_num_pages);?>
			   
			     <?php	}
			    	else
			    	{
			    	?>
			    	    <?php posts_nav_link(' '); ?>
			    	<?php
			    	}
			    ?>
			   
			     
			     </div>
                        <!-- end pagination -->
			     
			     <?php
			     }
			?>
			<?php	// Previous/next page navigation.


	// If no content, include the "No posts found" template.
} else {
	get_template_part( 'content', 'none' );
}
?>
			</div>
		</section>
		<!-- end section -->
	</div>
	
	
	
	

<?php get_footer(); ?>
