<?php

 /**
 * Template Name: Product Page
 * The main template file for display product page.
 *
 * @package WordPress
*/

get_header(); 




?>



<?php
			

				

				
get_template_part( 'content', 'page' );

				/**
				 * Functions hooked in to storefront_page_after action
				 *
				 * @hooked storefront_display_comments - 10
				 */
		?>	


<?php
$categories = get_post_meta(get_the_ID(), 'product_category', true);

if (!empty($categories)) {
    $categories = is_array($categories) ? $categories : json_decode($categories, true); ?>
<div class="container">
<div class=" m-0 p-0 pt-5 pb-5">
 <div class=" m-0 overflow-hidden ">
<div class="heading-block border-bottom-0 text-center" data-animate="zoomIn" >

<h2 class="text-transform-none fw-semibold mb-1 ">POWERFUL PAYLOADS</h2>
</div>
</div>

<div class="row ">
  <?php
foreach ($categories as $category):
    $cat_id = $category['value'];
    $cat_name = $category['name']; // Assuming 'value' is the key for category IDs

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'tax_query'      => array(
            array(
                'taxonomy' => 'product_category',
                'field'    => 'id',
                'terms'    => $cat_id,
            ),
        ),
    );

    // Create a new WP_Query instance
    $products = get_posts($args);

    if ($products) {
        foreach ($products as $product) {
            $product_id = $product->ID;
           
            

	 $drone_image = get_post_meta($product_id, 'product_image', true);
	     $drone_image = swap_get_image_url($drone_image);
	    
if (empty($drone_image)) $drone_image = TMPL . 'assets/assets/images/logo.svg';
            ?>
            <div class="col-lg-4 col-sm-6 mb-5">
                <a href="<?php echo get_permalink($product_id); ?>">
                    <div class="feature-box hover-effect h-p fbox-center fbox-bg fbox-light fbox-lg">
                        <div class="fbox-icon p-icon">
                            <i><img src="<?php echo esc_url($drone_image); ?>" class="border-0 bg-transparent" data-animate="fadeInRight" style="z-index: 2;" alt="<?php echo esc_attr(get_the_title($product_id)); ?>"></i>
                        </div>
                        <div class="fbox-content">
                            <h3 class="mb-4 text-transform-none ls-0"><a href="<?php echo get_permalink($product_id); ?>" class="text-dark"><?php echo esc_html($product->post_title); ?></a></h3>
                            <p class="mb-4"><?php
                                $excerpt = get_the_excerpt($product_id);
                                echo esc_html(string_limit_words($excerpt, 15)) . '...';
                                ?></p>
                        </div>
                        <a href="<?php echo get_permalink($product_id); ?>" class="btn btn-success" type="submit" data-animate="fadeInLeft">View Details</a>
                    </div>
                </a>
            </div>
            <?php
        }
    }
endforeach;
?>

	</div>

	</div>
</div>
<?php }
?>








<?php 
			$drone_ID = get_the_ID();
	 $drone_image = get_post_meta($drone_ID, 'product_image', true);
	     $drone_image = swap_get_image_url($drone_image);
	    
if (empty($drone_image)) $drone_image = TMPL . 'assets/assets/images/logo.svg';
			?>

<div class="mt-0 parallax mb-0 pb-5 pad-contact ">
<div class="container">
	<div class="row shadow bg-light border-dotted-line" style="background-image:url('https://www.aerosmart.ae/wp-content/uploads/2023/11/background_form.webp')">
<div class="col-lg-4 dark">
	<img src="<?php echo esc_url($drone_image); ?>" />
	<img class="form-dji-logo" src="https://www.aerosmart.ae/wp-content/uploads/2023/11/dji_logo.png" />
<h4 class="text-center mb-2 mt-2 gray-color">Request for a Quote</h4>
	
	<p class="offset-lg-1 fillup-text">
		Your journey into the extraordinary begins here. Share your details for a personalized <?php echo get_the_title(); ?>  quote and let your imagination soar. 
	</p>

</div>
<div class="col-lg-8 p-sm-5 p-3">
<?php echo do_shortcode('[contact-form-7 id="a26794c" title="Contact" html_id="template-contactform" html_class="row mb-0"]'); ?>
</div>
</div>
	
	

</div>
</div>
<?php get_footer(); ?>