<script type="text/javascript">
	<?php
	ob_start();
	include SWAP_TO_DIR . '/post_type/metaboxes/components/payments.php';
	$template = preg_replace("/\r|\n/", "", addslashes(ob_get_clean()));
	?>
    Vue.component('swap-payments', {
        props: ['saved_payments'],
        data: function () {
            return {
                payment_values : {},
                payments: {
                    cash: {
                        enabled: '',
                        name: "<?php esc_html_e('Offline payment', 'swap_theme_options'); ?>",
                        fields: {
                            description: {
                                type: 'textarea',
                                placeholder: '<?php esc_html_e('Payment method description', 'swap_theme_options'); ?>'
                            },
                        },
                    },
                    wire_transfer: {
                        enabled: '',
                        name: "<?php esc_html_e('Wire Transfer', 'swap_theme_options'); ?>",
                        fields: {
                            account_number: {
                                type: 'text',
                                placeholder: '<?php esc_html_e('Account number', 'swap_theme_options'); ?>'
                            },
                            holder_name: {
                                type: 'text',
                                placeholder: '<?php esc_html_e('Holder name', 'swap_theme_options'); ?>'
                            },
                            bank_name: {
                                type: 'text',
                                placeholder: '<?php esc_html_e('Bank name', 'swap_theme_options'); ?>'
                            },
                            swift: {
                                type: 'text',
                                placeholder: '<?php esc_html_e('Swift', 'swap_theme_options'); ?>'
                            },
                            description: {
                                type: 'textarea',
                                placeholder: '<?php esc_html_e('Payment method description', 'swap_theme_options'); ?>'
                            },
                        },
                    },
                    paypal: {
                        enabled: '',
                        name: "<?php esc_html_e('Paypal', 'swap_theme_options'); ?>",
                        fields: {
                            paypal_email: {
                                type: 'text',
                                placeholder: '<?php esc_html_e('PayPal Email', 'swap_theme_options'); ?>'
                            },
                            currency_code: {
                                type: 'select',
                                source: 'codes',
                                value : 'USD',
                                placeholder: '<?php esc_html_e('Currency code', 'swap_theme_options'); ?>'
                            },
                            paypal_mode: {
                                type: 'select',
                                source: 'modes',
                                value : 'sandbox',
                                placeholder: '<?php esc_html_e('PayPal mode', 'swap_theme_options'); ?>'
                            },
                            description: {
                                type: 'textarea',
                                placeholder: '<?php esc_html_e('Payment method description', 'swap_theme_options'); ?>'
                            },
                        },
                    },
                    stripe: {
                        enabled: '',
                        name: "<?php esc_html_e('Stripe', 'swap_theme_options'); ?>",
                        fields: {
                            stripe_public_api_key: {
                                type: 'text',
                                placeholder: '<?php esc_html_e('Publishable key', 'swap_theme_options'); ?>'
                            },
                            secret_key: {
                                type: 'text',
                                placeholder: '<?php esc_html_e('Secret key', 'swap_theme_options'); ?>'
                            },
                            description: {
                                type: 'textarea',
                                placeholder: '<?php esc_html_e('Payment method description', 'swap_theme_options'); ?>'
                            },
                        },
                    },
                },
                sources: {
                    codes: {
                        '<?php esc_html_e('Select Currency code', 'swap_theme_options'); ?>' : '',
                        '<?php esc_html_e('Australian dollar', 'swap_theme_options'); ?>' : 'AUD',
                        '<?php esc_html_e('Brazilian real', 'swap_theme_options'); ?>' : 'BRL',
                        '<?php esc_html_e('Canadian dollar', 'swap_theme_options'); ?>' : 'CAD',
                        '<?php esc_html_e('Czech koruna', 'swap_theme_options'); ?>' : 'CZK',
                        '<?php esc_html_e('Danish krone', 'swap_theme_options'); ?>' : 'DKK',
                        '<?php esc_html_e('Euro', 'swap_theme_options'); ?>' : 'EUR',
                        '<?php esc_html_e('Hong Kong dollar', 'swap_theme_options'); ?>' : 'HKD',
                        '<?php esc_html_e('Hungarian forint 1', 'swap_theme_options'); ?>' : 'HUF',
                        '<?php esc_html_e('Indian rupee', 'swap_theme_options'); ?>' : 'INR',
                        '<?php esc_html_e('Israeli new shekel', 'swap_theme_options'); ?>' : 'ILS',
                        '<?php esc_html_e('Japanese yen 1', 'swap_theme_options'); ?>' : 'JPY',
                        '<?php esc_html_e('Malaysian ringgit 2	', 'swap_theme_options'); ?>' : 'MYR',
                        '<?php esc_html_e('Mexican peso', 'swap_theme_options'); ?>' : 'MXN',
                        '<?php esc_html_e('New Taiwan dollar 1', 'swap_theme_options'); ?>' : 'TWD',
                        '<?php esc_html_e('New Zealand dollar', 'swap_theme_options'); ?>' : 'NZD',
                        '<?php esc_html_e('Norwegian krone', 'swap_theme_options'); ?>' : 'NOK',
                        '<?php esc_html_e('Philippine peso', 'swap_theme_options'); ?>' : 'PHP',
                        '<?php esc_html_e('Polish złoty', 'swap_theme_options'); ?>' : 'PLN',
                        '<?php esc_html_e('Pound sterling', 'swap_theme_options'); ?>' : 'GBP',
                        '<?php esc_html_e('Russian ruble', 'swap_theme_options'); ?>' : 'RUB',
                        '<?php esc_html_e('Singapore dollar', 'swap_theme_options'); ?>' : 'SGD',
                        '<?php esc_html_e('Swedish krona', 'swap_theme_options'); ?>' : 'SEK',
                        '<?php esc_html_e('Swiss franc', 'swap_theme_options'); ?>' : 'CHF',
                        '<?php esc_html_e('Thai baht', 'swap_theme_options'); ?>' : 'THB',
                        '<?php esc_html_e('United States dollar', 'swap_theme_options'); ?>' : 'USD',
                    },
                    modes : {
                        '<?php esc_html_e('Sandbox', 'swap_theme_options'); ?>' : 'sandbox',
                        '<?php esc_html_e('Live', 'swap_theme_options'); ?>' : 'live',
                    }
                }
            }
        },
        template: '<?php echo $template; ?>',
        mounted: function () {
            if (this.saved_payments) this.setPaymentValues();
        },
        methods: {
            setPaymentValues() {
                var vm = this;
                for(var payment_method in vm.payments) {
                    if (!vm.payments.hasOwnProperty(payment_method) && !vm.saved_payments.hasOwnProperty(payment_method)) continue;
                    vm.payments[payment_method]['enabled'] = vm.saved_payments[payment_method]['enabled'];

                    for(var field_name in vm.payments[payment_method]['fields']) {
                        vm.$set(vm.payments[payment_method]['fields'][field_name], 'value', vm.saved_payments[payment_method]['fields'][field_name]);
                    }
                }
            },
            getPaymentValues() {
                var vm = this;
                for(var payment_method in vm.payments) {

                    if (!vm.payments.hasOwnProperty(payment_method)) continue;
                    vm.payment_values[payment_method] = {
                        'enabled' : vm.payments[payment_method]['enabled'],
                    };

                    if(typeof vm.payment_values[payment_method]['fields'] === 'undefined') vm.payment_values[payment_method]['fields'] = {};

                    for(var field_name in vm.payments[payment_method]['fields']) {
                        if (! vm.payments[payment_method]['fields'].hasOwnProperty(field_name)) continue;
                        var value = (typeof vm.payments[payment_method]['fields'][field_name]['value'] === 'undefined') ? '' : vm.payments[payment_method]['fields'][field_name]['value'];

                        vm.payment_values[payment_method]['fields'][field_name] = value;

                    }
                }

                this.$emit('update-payments', vm.payment_values);
            }
        },
        watch: {
            payments: {
                handler: function () {
                    this.getPaymentValues();
                },
                deep: true
            },
        }
    })
</script>