<?php
/**
 * @var $metabox_name
 * @var $field_name
 * @var $section_name
 *
 */

if(!empty($metabox['args']['swap_to_settings'])) {
    $option_name = $metabox['args']['swap_to_settings'][$section_name]['fields'][$field_name]['options'];
} else {
    $option_name = $metabox['args'][$metabox_name][$section_name]['fields'][$field_name]['options'];
};

$field_key = "data['{$section_name}']['fields']['{$field_name}']";

include SWAP_TO_DIR . '/post_type/metaboxes/components_js/multiselect.php';

$options = apply_filters("swap_multiselect_options_{$option_name}", array());

?>

<label v-html="<?php echo esc_attr($field_key); ?>['label']"></label>

<swap-multiselect v-bind:options='<?php echo preg_replace("/&#?[a-z0-9]+;/i", "", str_replace('\'', '', json_encode($options))); ?>'
                  v-bind:selected_options='<?php echo esc_attr($field_key); ?>["value"]'
                  v-on:get-selects="<?php echo esc_attr($field_key); ?>['value'] = $event"></swap-multiselect>

<input type="hidden"
       name="<?php echo esc_attr($field_name); ?>"
       v-model="<?php echo esc_attr($field_key); ?>['value']"/>